<?php

namespace App\Http\Controllers;

use App\Traits\PaginationTrait;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;

class OrderController extends Controller
{
    //
    use PaginationTrait;

    public function index($location_id='',$date_from='',$date_to='',$order_type=''){  
        //'both', means order type is both(pickup and delivery)

        if(!Auth::check()){
            return redirect("login")->with('success','Opps! You do not have access');
        }
        
        //dd($user->website);

        
 
        //dd($orders);
        
        //$orders = $this->paginate($orders,10);

        $orders=$this->api_get_orders($location_id,$date_from,$date_to,$order_type);

        $locations=$this->api_get_locations();

        //print_r($locations); exit;

        //print_r($orders); exit;
        return view('order.list', compact('orders','locations'));

    }

    public function order_items(Request $request){

        $validated = $request->validate([
            'order_id' => 'required'
        ]);

        $order_id=$request->input('order_id');
        $order_time=$request->input('order_time');
        $total_amount=$request->input('total_amount');


        $order_items=$this->api_get_order_items($order_id);

        $html = view('order.items', compact('order_items','order_time','total_amount','order_id'))->render();

        $html = stripslashes($html);

        echo $html;
    }

    public function order_status(Request $request){

        $validated = $request->validate([
            'order_id' => 'required',
            'message' => 'required',
            'purpose' => 'required'
        ]);

        $order_id=$request->input('order_id');
        $message=$request->input('message');
        $purpose=$request->input('purpose');


        $response=$this->api_update_order_status($order_id,$purpose,$message);

        echo json_encode($response);
    }


    

    public function order_location(Request $request){

        $validated = $request->validate([
            'location_id' => 'required'
        ]);

        $location_id=$request->input('location_id');


        Session::put('location_id', $location_id);

        echo json_encode(['status'=>1,'location_id'=>
        Session::all()]);
    }


    public function api_update_order_status($order_id,$purpose,$message){

        $client = new Client();
        $user = Auth::user();
        $url = $user->website."api/order-status";

        $params = [
            'order_id'=>$order_id,
            'message'=>$message,
            'purpose'=>$purpose,
        ];

        $headers = [
            'X-API-KEY' => 'test1'
        ];

        $response = $client->request('GET', $url, [
            'query' => $params,
            'headers' => $headers,
            'verify'  => false,
        ]);


        $status = json_decode($response->getBody(),true);

        return $status;
    }


  
    public function order_filter(Request $request){
    

        $validated = $request->validate([
            'date_from' => 'required',
            'date_to' => 'required',
            'order_type' => 'required',
            'location_id' => 'required'
        ]);


        $date_from=$request->input('date_from');
        $date_to=$request->input('date_to');
        $location_id=$request->input('location_id');
        $order_type=$request->input('order_type');
        
        
        $orders=$this->api_get_orders($location_id,$date_from,$date_to,$order_type);

    
        $html = view('order.orders', compact('orders'))->render();

        $html = stripslashes($html);

        echo $html;
       

    }

    public function api_get_locations(){

        $client = new Client();
        $user = Auth::user();
        $url = $user->website."api/get-locations";

        $params = [
            
        ];

        $headers = [
            'X-API-KEY' => 'test1'
        ];

        $response = $client->request('GET', $url, [
            'query' => $params,
            'headers' => $headers,
            'verify'  => false,
        ]);


        $locations = json_decode($response->getBody(),true);

        return $locations;
    }


    public function api_get_orders($location_id,$date_from,$date_to,$order_type){

        $client = new Client();
        $user = Auth::user();
        $url = $user->website."api/get-orders";

        $params = [
            'location_id'=>!empty($location_id)?$location_id:Session::get('location_id'),
            'date_from'=>!empty($date_from)?$date_from:date('Y/m/d'),
            'date_to'=>!empty($date_to)?$date_to:date('Y/m/d'),
            'order_type'=>!empty($order_type)?$order_type:'both'
        ];

        $headers = [
            'X-API-KEY' => 'test1'
        ];

        $response = $client->request('GET', $url, [
            'query' => $params,
            'headers' => $headers,
            'verify'  => false,
        ]);


        $orders = json_decode($response->getBody(),true);

        return $orders;
    }

    public function api_get_order_items($order_id){

        $client = new Client();
        $user = Auth::user();
        $url = $user->website."api/get-order-items";

        $params = [
            'order_id'=>$order_id,
        ];

        $headers = [
            'X-API-KEY' => 'test1'
        ];

        $response = $client->request('GET', $url, [
            'query' => $params,
            'headers' => $headers,
            'verify'  => false,
        ]);


        $orders = json_decode($response->getBody(),true);

        return $orders;
    }
    
    
}
