<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    //
    public function index()
    {
        if(Auth::check()){
            return redirect("orders");
        }

        return view('auth.login');
    }  
      
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function registration()
    {
        return view('auth.login');
    }
      
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function postLogin(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required'
        ]);
   
        if($request->rememberme===null){
            setcookie('login_email',$request->email,100);
            setcookie('login_pass',$request->password,100);
         }
        else{
            setcookie('login_email',$request->email,time()+60*60*24*100);
            setcookie('login_pass',$request->password,time()+60*60*24*100);

        }

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            return redirect()->intended('orders')
                        ->with('success','You have Successfully loggedin');
        }
  
        return redirect("login")->with('error', 'Oppes! You have entered invalid credentials');
    }
      
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function postRegistration(Request $request)
    {  
        /*$request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'website' => 'required',
            'password' => 'required|min:6',
            'terms_conditions'=>'required'
        ]);*/
        
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'website' => 'required',
            'password' => 'required|confirmed|min:6',
            'password_confirmation'=>'required',
            'terms_conditions'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('register')
                        ->withErrors($validator)
                        ->withInput();
        }

        $data = $request->all();
        $check = $this->create($data);
         
        return redirect("orders")->with('success','Great! You have Successfully loggedin');
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    /*public function dashboard()
    {
        print_r(Auth::user());

        if(Auth::check()){
            return view('orders');
        }
  
        return redirect("login")->with('success','Opps! You do not have access');
    }*/
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function create(array $data)
    {
      return User::create([
        'name' => $data['name'],
        'email' => $data['email'],
        'website' => $data['website'],
        'password' => Hash::make($data['password'])
      ]);
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function logout() {
        Session::flush();
        Auth::logout();
  
        return Redirect('login');
    }

}
